entry Code_Reset.enter;

import "../IMPORT/register.h";
import "../IMPORT/entryReg.h";

block specialReg {
	abs {
		public currMode			=	0x1;
		public asn				=	0x2;
		public palBase			=	0x3;
		public prevPC			=	0x4;
		public prevPAL			=	0x5;
		public ptbr				=	0x6;
		public kgp				=	0x7;
		public ksp				=	0x8;
		public usp				=	0x9;
		public virtAddr			=	0xa;
		public arithSum			=	0xb;
		public regMask			=	0xc;
		public dataSum			=	0xd;
		public nest				=	0xe;

		public itb				=	0x20;
		public dtb				=	0x21;
		public itbcontrol		=	0x22;
		public dtbcontrol		=	0x23;
		public TLBTag			=	0x24;

		public intReq			=	0x30;
		public intEnb			=	0x31;
		public receive			=	0x32;
		public transmit			=	0x33;
		public clock			=	0x34;

		public temp				=	0x100;
		public kentry			=	0x200;

		public sptbr			=	0x600;
		public sksp				=	0x700;
		public susp				=	0x800;
		}
	}

block exc {
	abs {
		public	user		=	1;
		public kernel		=	0;
		}
	local {
		public mode:
			quad;
		public intEnb:
			quad;
		public pc:
			quad;
		public gp:
			quad;
		public a0:
			quad;
		public a1:
			quad;
		public a2:
			quad;
		public max:
		}
	}
	
block dataSumFlag {
	abs {
		public	WR			=	0x1;
		public ACV			=	0x2;
		public FOR			=	0x4;
		public FOW			=	0x8;
		public REG			=	0x1f0;
		public OPCODE		=	0x7e00;
		public MASK			=	0x7fff;
		public ERROR		=	ACV | FOR | FOW;
		}
	}
	
block PTEFlag {
	abs {
		public VALID		= 0x0000000000000001;	// 0
		public FOR			= 0x0000000000000002;	// 1
		public FOW			= 0x0000000000000004;	// 2
		public FOE			= 0x0000000000000008;	// 3
		public KRE			= 0x0000000000000010;	// 4
		public URE			= 0x0000000000000020;	// 5
		public KWE			= 0x0000000000000040;	// 6
		public UWE			= 0x0000000000000080;	// 7
		public KEE			= 0x0000000000000100;	// 8
		public UEE			= 0x0000000000000200;	// 9
		public ASM			= 0x0000000000000400;	// 10
		public SOFT			= 0x00000000fffff800;	// 11 - 31
		public PPAGE		= 0x000003ff00000000;	// 32 - 41
		public MASK			= 0x000003ffffffffff;
		public USERPAGE		= URE | UWE | UEE;
		}
	}
	
block MMFault {
	abs {
		public	TNV			=	0;
		public ACV			=	1;
		public FOR			=	2;
		public FOE			=	3;
		public FOW			=	4;
		}
	}

block tlbControl {
	abs {
		public TLBDELALL		= 0x0;
		public TLBDELASM		= 0x1;
		public TLBDELNOTASM		= 0x2;
		public TLBDELUSER		= 0x3;
		}
	}
	
block IFault {
	abs {
		public	BPT			=	0;
		public BUGCHK		=	1;
		public GENTRAP		=	2;
		public FEN			=	3;
		public OPCDEC		=	4;
		}
	}
	
block XFC {
	abs {
		public STOP				= 0x0;
		public UPDATE			= 0x1;
		public SLEEP			= 0x2;
		public GETCHAR			= 0x10;
		public PUTCHAR			= 0x11;
		public GETINPUTFILE		= 0x70;
		public FORK				= 0x80;
		public EXEC				= 0x81;
		}
	}

block sav uses specialReg {
	abs {
		public a0			=	temp + 0x0;
		public a1			=	temp + 0x1;
		public a2			=	temp + 0x2;
		public pc			=	temp + 0x3;
		public intEnb		=	temp + 0x4;
		public ra			=	temp + 0x5;
		public t0			=	temp + 0x6;
		}
	}

block savPAL uses specialReg {
	abs {
		public a0			=	temp + 0x10;
		public a1			=	temp + 0x11;
		public a2			=	temp + 0x12;
		public pc			=	temp + 0x13;
		public intEnb		=	temp + 0x14;
		public ra			=	temp + 0x15;
		public t0			=	temp + 0x16;
		}
	}
//________________________________________________________________
// Table of PAL entry points									//
//________________________________________________________________

block PALEntry {
	code {
	tableBase:
	Vector_Reset:
		long	Code_Reset.enter - tableBase;			//	00
	Vector_Mchk:
		long	0;										//	01
	Vector_Arith:
		long	0;										//	02
	Vector_Interrupt:
		long	0;										//	03
	Vector_D_Fault:
		long	0;										//	04
	Vector_ITB_Miss:
		long	0;										//	05
	Vector_ITB_ACV:
		long	0;										//	06
	Vector_DTB_Miss_Native:
		long	0;										//	07
	Vector_DTB_Miss_PAL:
		long	0;										//	08
	Vector_Unalign:
		long	0;										//	09
	Vector_OPCDEC:
		long	0;										//	0a
	Vector_FEN:
		long	0;										//	0b
	Vector_Call_PAL_Kernel:
														//	0c - 4b
		long	Code_Halt.enter - tableBase;			//	00 reserved for OSF/1 - halt
		long	Code_GetChar.enter - tableBase;			//	01
		long	Code_PutChar.enter - tableBase;			//	02 reserved for OSF/1 - draina
		long	0;										//	03
		long	0;										//	04
		long	0;										//	05
		long	0;										//	06
		long	0;										//	07
		long	0;										//	08
		long	0;										//	09
		long	0;										//	0a
		long	0;										//	0b
		long	0;										//	0c
		long	0;										//	0d
		long	0;										//	0e
		long	0;										//	0f
		long	0;										//	10
		long	0;										//	11
		long	0;										//	12
		long	0;										//	13
		long	0;										//	14
		long	0;										//	15
		long	0;										//	16
		long	0;										//	17
		long	0;										//	18
		long	0;										//	19
		long	0;										//	1a
		long	0;										//	1b
		long	0;										//	1c
		long	0;										//	1d
		long	0;										//	1e
		long	0;										//	1f
		long	0;										//	20
		long	0;										//	21
		long	0;										//	22
		long	0;										//	23
		long	0;										//	24
		long	0;										//	25
		long	0;										//	26
		long	0;										//	27
		long	0;										//	28
		long	0;										//	29
		long	0;										//	2a
		long	0;										//	2b reserved for OSF/1 - wrfen
		long	0;										//	2c
		long	0;										//	2d reserved for OSF/1 - wrvptptr
		long	0;										//	2e
		long	0;										//	2f
		long	Code_Swpctx.enter - tableBase;			//	30 reserved for OSF/1 - swpctx
		long	0;										//	31 reserved for OSF/1 - wrval
		long	0;										//	32 reserved for OSF/1 - rdval
		long	0;										//	33 reserved for OSF/1 - tbi
		long	Code_Wrent.enter - tableBase;			//	34 reserved for OSF/1 - wrent
		long	0;										//	35 reserved for OSF/1 - swpipl
		long	0;										//	36 reserved for OSF/1 - rdps
		long	Code_Wrkgp.enter - tableBase;			//	37 reserved for OSF/1 - wrkgp
		long	Code_Wrusp.enter - tableBase;			//	38 reserved for OSF/1 - wrusp
		long	0;										//	39
		long	Code_Rdusp.enter - tableBase;			//	3a reserved for OSF/1 - rdusp
		long	0;										//	3b reserved for OSF/1
		long	0;										//	3c reserved for OSF/1 - whami
		long	Code_Retsys.enter - tableBase;			//	3d reserved for OSF/1 - retsys
		long	0;										//	3e
		long	Code_Rti.enter - tableBase;				//	3f reserved for OSF/1 - rti
	
	Vector_Call_PAL_User:
														//	4c - 8b
		long	Code_Bpt.enter - tableBase;				//	80 reserved for OSF/1 - bpt
		long	0;										//	81 reserved for OSF/1 - bugchk
		long	0;										//	82
		long	Code_Callsys.enter - tableBase;			//	83 reserved for OSF/1 - callsys
		long	0;										//	84
		long	0;										//	85
		long	0;										//	86 reserved for OSF/1 - imb
		long	0;										//	87
		long	0;										//	88
		long	0;										//	89
		long	0;										//	8a
		long	0;										//	8b
		long	0;										//	8c
		long	0;										//	8d
		long	0;										//	8e
		long	0;										//	8f
		long	0;										//	90
		long	0;										//	91
		long	0;										//	92
		long	0;										//	93
		long	0;										//	94
		long	0;										//	95
		long	0;										//	96
		long	0;										//	97
		long	0;										//	98
		long	0;										//	99
		long	0;										//	9a
		long	0;										//	9b
		long	0;										//	9c
		long	0;										//	9d
		long	0;										//	9e reserved for OSF/1 - rdunique
		long	0;										//	9f reserved for OSF/1 - wrunique
		long	0;										//	a0
		long	0;										//	a1
		long	0;										//	a2
		long	0;										//	a3
		long	0;										//	a4
		long	0;										//	a5
		long	0;										//	a6
		long	0;										//	a7
		long	0;										//	a8
		long	0;										//	a9
		long	0;										//	aa reserved for OSF/1 - gentrap
		long	0;										//	ab
		long	0;										//	ac
		long	0;										//	ad
		long	0;										//	ae
		long	0;										//	af
		long	0;										//	b0
		long	0;										//	b1
		long	0;										//	b2
		long	0;										//	b3
		long	0;										//	b4
		long	0;										//	b5
		long	0;										//	b6
		long	0;										//	b7
		long	0;										//	b8
		long	0;										//	b9
		long	0;										//	ba
		long	0;										//	bb
		long	0;										//	bc
		long	0;										//	bd
		long	0;										//	be
		long	0;										//	bf
	Vector_Call_PAL_End:
		}
	}
	
//________________________________________________________________
// Reset														//
//________________________________________________________________
block Code_Reset uses register, specialReg {
	code {
	public enter:
//		hw_mtpr	$zero,	itbcontrol;
//		hw_mtpr	$zero,	dtbcontrol;
		hw_mfpr	$gp,	kgp;
		hw_mfpr	$sp,	susp($zero);
		hw_mtpr	$sp,	usp;
		hw_mfpr	$sp,	sksp($zero);
		hw_mtpr	$sp,	ksp;
		hw_rei;
		}
	}

//________________________________________________________________
// Swap context													//
//________________________________________________________________
block Code_Swpctx uses register, specialReg {
	code {
	public enter:
		hw_mfpr	$v0,	asn;
		hw_mfpr	$t0,	ptbr;
		hw_mtpr	$t0,	sptbr($v0);
	
		hw_mtpr	$sp,	sksp($v0);
	
		hw_mfpr	$t0,	usp;
		hw_mtpr	$t0,	susp($v0);
		
		hw_mtpr	$a0,	asn;
		
		hw_mfpr	$t0,	sptbr($a0);
		hw_mtpr	$t0,	ptbr;
		
		hw_mfpr	$sp,	sksp($a0);
		
		hw_mfpr	$t0,	susp($a0);
		hw_mtpr	$t0,	usp;
		
		hw_rei;
		}
	}
//________________________________________________________________
// Write kernel entry											//
//________________________________________________________________
block Code_Wrent uses register, specialReg {
	code {
	public enter:
		hw_mtpr	$a0,	kentry($a1);
		hw_rei;
		}
	}
//________________________________________________________________
// Write Kernel GP												//
//________________________________________________________________
block Code_Wrkgp uses register, specialReg {
	code {
	public enter:
		hw_mtpr	$a0,	kgp;
		hw_rei;
		}
	}
//________________________________________________________________
// Write USP													//
//________________________________________________________________
block Code_Wrusp uses register, specialReg {
	code {
	public enter:
		hw_mtpr	$a0,	usp;
		hw_rei;
		}
	}
//________________________________________________________________
// Read USP														//
//________________________________________________________________
block Code_Rdusp uses register, specialReg {
	code {
	public enter:
		hw_mfpr	$v0,	usp;
		hw_rei;
		}
	}
//________________________________________________________________
// Return from system call										//
//________________________________________________________________
block Code_Retsys uses register, specialReg {
	code {
	public enter:
		ldq		$gp,	exc.gp($sp);

		ldq		$t0,	exc.pc($sp);
		hw_mtpr	$t0,	prevPC;
		
		hw_mtpr	$zero,	intEnb;

		mov		exc.user,	$t0;
		hw_mtpr	$t0,	currMode;

		lda		$sp,	exc.max($sp);
		hw_mtpr	$sp,	ksp;
		hw_mfpr	$sp,	usp;
		hw_rei;
		}
	}
//________________________________________________________________
// Return from trap or interrupt								//
//________________________________________________________________
block Code_Rti uses register, specialReg {
	code {
	public enter:
		hw_mtpr	$t0,	sav.t0;

		ldq		$a2,	exc.a2($sp);
		ldq		$a1,	exc.a1($sp);
		ldq		$a0,	exc.a0($sp);
		ldq		$gp,	exc.gp($sp);

		ldq		$t0,	exc.pc($sp);
		hw_mtpr	$t0,	prevPC;
		
		ldq		$t0,	exc.intEnb($sp);
		hw_mtpr	$t0,	intEnb;

		ldq		$t0,	exc.mode($sp);
		hw_mtpr	$t0,	currMode;

		lda		$sp,	exc.max($sp);
		beq		$t0,	retKernel;
	retUser:
		hw_mtpr	$sp,	ksp;
		hw_mfpr	$sp,	usp;
	retKernel:
		hw_mfpr	$t0,	sav.t0;
		hw_rei;
		}
	}
//________________________________________________________________
// Breakpoint													//
//________________________________________________________________
block Code_Bpt uses register, specialReg {
	code {
	public enter:
		call_xfc		XFC.STOP;
		hw_rei;
		}
	}
//________________________________________________________________
// Call system													//
//________________________________________________________________
block Code_Callsys uses register, specialReg, entryReg {
	code {
	public enter:
		hw_mtpr	$t0,	sav.t0;
		mov		exc.user,	$t0;
		hw_mtpr	$zero,	currMode;
		hw_mtpr	$sp,	usp;
		hw_mfpr	$sp,	ksp;
		lda		$sp,	-exc.max($sp);

		stq		$t0,	exc.mode($sp);
		
		hw_mfpr	$t0,	intEnb;
		stq		$t1,	exc.intEnb($sp);
		
		hw_mfpr	$t0,	prevPC;
		stq		$t0,	exc.pc($sp);
		
		stq		$gp,	exc.gp($sp);
	
		hw_mfpr	$gp,	kgp;
		
		mov		entSys,	$t0;
		hw_mfpr	$t0,	kentry($t0);
		hw_mtpr	$t0,	prevPC;
		
		hw_mfpr	$t0,	sav.t0;
		hw_rei;
		}
	}

//________________________________________________________________
// Halt															//
//________________________________________________________________
block Code_Halt uses register, specialReg {
	code {
	public enter:
	loop:
		call_xfc		XFC.STOP;
		br		loop;
		}
	}

//________________________________________________________________
// GetChar														//
//________________________________________________________________
block Code_GetChar uses register, specialReg {
	code {
	public enter:
		call_xfc		XFC.GETCHAR;
		hw_rei;
		}
	}

//________________________________________________________________
// PutChar														//
//________________________________________________________________
block Code_PutChar uses register, specialReg {
	code {
	public enter:
		call_xfc		XFC.PUTCHAR;
		hw_rei;
		}
	}

